﻿using Autofac;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Configuration;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using System.Reflection;
namespace AHOBPR_WcfService
{
    public class Bootstrapper
    {
        /// <summary>
        /// Configures and builds Autofac IOC container.
        /// </summary>
        /// <returns></returns>
        public static IContainer BuildContainer()
        {
            var builder = new ContainerBuilder();

            // register services

            builder.RegisterType<RegistrantRetirementImporter>().As<IRegistrantUpdater>();
            builder.RegisterType<VeteranStatusImporter>().As<IRegistrantUpdater>();
            builder.RegisterType<DoDDeploymentImporter>().As<IDeploymentImporter>();

            // build container
            return builder.Build();
        }
    }
}